<?= $this->extend( theme_path('__layout/base') ) ?>

<?= $this->section("content") ?>

    <!-- ======= pages Section ======= -->
    <section id="single-page-title" class="d-flex align-items-center justify-content-center">
    <div class="container text-center">
    <div class="row justify-content-center">
    <div class="title-pages"><?= esc( $title ) ?></div>
    </div>
    </section><!-- End pages -->

    <div class="container">

    <!-- Content Body Section -->
    <div class="row row-eq-spacing my-5">
    <div class="col-lg-7 col-xl-9">

        <!-- leaderboard ad-->
        <?php if( has_display_banner_ad('view.banner.player-bottom', $ads) ) {
        echo display_banner_ad('view.banner.player-bottom', $ads);
        } ?>

        <?php the_embed_player( $activeMovie ) ?>

        <!-- leaderboard ad-->
        <?php if( has_display_banner_ad('view.banner.player-top', $ads) ) {
        echo display_banner_ad('view.banner.player-top', $ads);
        } ?>

        <?php if(! empty($seasons)) : ?>

        <div class="card seasons-list" data-series-imdb="<?= $activeMovie->series_imdb_id ?>">
        <div class="input-group">
        <?= format_seasons_list( $activeMovie, $seasons ) ?>
        </div>
        </div>

        <?php endif; ?>

        <div class="card">
	    <div class="three">
	    <h2 class="card-title">
        <?= lang('General.storyline') ?>
        </h2>
        </div> 
	    <p class="text-desc_"><?= esc( $activeMovie->description ) ?></p>    
        </div>

        <div class="card">
        <?php the_embed_links_group( $activeMovie ); ?>
        </div>
        

        </div>
        <div class="col-lg-5 col-xl-3 mt-15 mt-lg-0">
        <div class="w-300 mw-full ">
        <div class="m-0 mb-10">
        <img src="<?= poster_uri( $activeMovie->poster ) ?>" class="img-fluid w-full" alt="">
        <div class="row align-items-center box-poster-quality">
        <div class="col">
        Video Quality
        </div>
        <div class="col-auto">
        <?= esc( $activeMovie->quality ) ?>
        </div>
        </div>
        </div>
        <?php if(! empty( $activeMovie->trailer )): ?>
        <button class="btn-trailers" data-toggle="modal" data-target="trailer-modal"><i class="fa fa-video-camera" aria-hidden="true"></i>
        &nbsp; <?= lang('General.watch_trailer') ?></button>
        <?php endif; ?>
        </div>

        <div class="box-meta">
        <?php the_movie_meta_info( $activeMovie ) ?>
        </div>
        <!-- sidebar ad-->
        <?php if( has_display_banner_ad('view.banner.sidebar', $ads) ) {
        echo display_banner_ad('view.banner.sidebar', $ads);
        } ?>
        </div>
    </div>
    <!-- ./ End Content Body Section -->
    </div>


    <?= $this->endSection() ?>

    <?= $this->section('end-of-content') ?>

    <?php if(! empty( $activeMovie->trailer )): ?>
    <!-- Modal Trailer -->
    <div class="modal" id="trailer-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
    <div class="modal-content modal-content-media w-600 p-10"> <!-- w-500 = width: 50rem (500px) -->
    <a href="javascript:void(0)" class="close" role="button" aria-label="Close" data-dismiss="modal" type="button">
    <span aria-hidden="true">&times;</span>
    </a>
    <div class="iframe-wrapper">
    <iframe class="lazy" width="560" height="315" data-src="<?= esc( $activeMovie->getMovieTrailer() ) ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>
    </iframe>
    </div>
    </div>
    </div>
    </div>
    <?php endif; ?>
    <?= $this->endSection() ?>