<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <?php if( has_site_favicon() ): ?>
        <link rel="shortcut icon" href="<?= site_favicon() ?>" type="image/x-icon">
        <link rel="icon" href="<?= site_favicon() ?>" type="image/x-icon">
    <?php endif; ?>
    <link href="<?= theme_assets('/fontawesome_pro/css/all.css') ?>" rel="stylesheet" />
    <link href="<?= theme_assets('/fontawesome_pro/css/all.min.css') ?>" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="<?= theme_assets('/css/template.min.css?v=1.2') ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?= theme_assets('/css/custom.min.css?v=1.2') ?>">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha256-eZrrJcwDc/3uDhsdt61sL2oOBY362qM3lon1gyExkL0=" crossorigin="anonymous">

    <title><?= ! empty($links) ? $movie->getMovieTitle() : 'movie not found' ?> </title>
    <style>
        body{
            background-color: var(--dm-card-bg-color) !important;
        }
    </style>

    <!-- header custom codes-->
    <?= header_custom_codes() ?>

</head>
<body  class="dark-mode overflow-y-hidden">
<?php if(! empty($links)): ?>

    <div id="embed-player" data-movie-id="<?= encode_id( $movie->id ) ?>">
        <div class="sticky-alerts bottom-0 top-auto mb-15"></div>
        <div class="top-bar">
        <div class="d-none d-sm-flex align-items-center"></div>

        <div class="d-inline-block d-sm-none"></div>
        <div class=" d-flex align-items-center">

        <div class="dropdown mr-5 <?= count( $links ) == 1 ? 'd-none' : '' ?>" id="servers" >
        <button class="btn-server-list active-server" data-toggle="dropdown"  type="button" id="dropdown-toggle-btn-1" aria-haspopup="true" aria-expanded="false">
        <i class="fa-duotone fa-solid fa-server"></i>&nbsp;
        <span class="name"><?= reset( $links ) ?></span>&nbsp;
        <i class="fa fa-angle-down ml-5" aria-hidden="true"></i> <!-- ml-5 = margin-left: 0.5rem (5px) -->
        </button>
        <div class="dropdown-menu" aria-labelledby="dropdown-toggle-btn-1">
            
        <?php
        foreach ($links as $id => $link) {
        echo '<a href="javascript:void(0)" onClick="Player.play(false, this)" class="server dropdown-item" data-id="' . $id . '"> ' . esc( $link ) . ' </a>';
        }
        ?>
        </div>
        </div>
        </div>
        </div>
        <button class="toggle-top-bar toggle-btn-short btn position-fixed font-weight-bold top-0 right-0  z-10" style="display: none"><i class="fa fa-sliders" aria-hidden="true"></i>
        </button>
        <div class="main-content">
        <div class="cover" style="background: linear-gradient( rgba(0, 0, 0, 0.0), rgba(0, 0, 0, 0.0) ), url(<?= banner_uri(
        $movie->banner
        ) ?>);"></div>
        <div class="play-btn" onclick="Player.play()">
        <img src="<?= theme_assets('/images/icons/play-white.png') ?>" class="h-25" alt="play-btn">
        </div>
        <div class="frame">
        <iframe id="ve-iframe" width="100%" scrolling="no" allowfullscreen="true" frameborder="0"></iframe>
        </div>
        <div class="loader">
        <div class="lds-ripple"><div></div><div></div></div>
        <div class="ve-text">
        <?= lang('Embed.please_wait') ?>
        </div>
        </div>
        <div class="error">
                <span class="lbl font-size-14"> <?= lang('Embed.unknown_error_occurred') ?> </span>
                <span class="msg"></span>
            </div>
            <div class="g-recaptcha" data-sitekey="<?= esc( get_config('gcaptcha_site_key') ) ?>"
                 data-badge="inline" data-size="invisible" data-callback="set_captcha_response"></div>

        </div>
    </div>

    <?php else: ?>

    <div class="movie-not-found">
        <div class="img-wrap text-center">
            <img src="<?= theme_assets('/images/icons/cat.png') ?>" class="w-100" alt="">
            <h3 class="font-size-24 text-muted">
                <?php if( $serverNotFound ){
                    echo lang('Embed.server_not_found');
                }else if(empty( $movie )){
                    echo lang('Embed.movie_not_found');
                }else {
                    echo lang('Embed.streaming_links_not_found');
                } ?>
            </h3>
            <hr>
            <?php if( $serverNotFound ): ?>
                <a href="<?= $movie->getEmbedLink(true) ?>?load-server=1"> <?= lang('Embed.load_another_server') ?> </a>
            <?php endif; ?>
        </div>
    </div>

<?php endif; ?>




<script> const BASE_URL = '<?= site_url() ?>'; </script>


<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<?php if( get_config('is_stream_gcaptcha_enabled') ): ?>
    <script  src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>

<script src="<?= theme_assets('js/template.min.js?v=1.2') ?>"></script>
<script src="<?= theme_assets('js/custom.min.js?v=1.2') ?>"></script>
<script src="<?= theme_assets('js/player.min.js?v=1.2') ?>"></script>

<!--footer custom codes-->
<?= footer_custom_codes () ?>

<!--popAds-->
<?php if(isset( $ads )) {
    echo display_pop_ad( $ads );
}  ?>

</body>
</html>