
    <nav class="navbar">
    <div class="container">
    <a href="<?= site_url() ?>" class="navbar-brand">
    <?php if(! has_site_logo()): ?>
    <h1 class="ve-logo-text"> <?= esc( site_name() ) ?> </h1>
    <?php else: ?>
    <img src="<?= site_logo() ?>" class="h-20 h-sm-30 logo-navbar_" alt="">
    <?php endif; ?>
    </a>

    <?php $uri = http_uri(); ?>
    <!-- Navbar nav -->
    <ul class="navbar-nav mx-auto d-none d-md-flex"> <!-- d-none = display: none, d-md-flex = display: flex on medium screens and up (width > 768px) -->
    <li class="nav-item <?php if( $uri->getPath() == '/' || $uri->getSegment(1) === 'home'  ) echo 'active' ?>   ">
    <a href="<?= site_url() ?>" class="nav-link font-weight-semi-bold"><i class="fa-light fa-house"></i>&nbsp;
    <?= lang('TopNav.home') ?>
    </a>
    </li>

    <li class="nav-item <?php if($uri->getTotalSegments() >= 2 && $uri->getSegment(2) === 'movies'  ) echo 'active' ?>">
    <a href="<?= library_url() ?>" class="nav-link font-weight-semi-bold "><i class="fa-light fa-film"></i>&nbsp;
    <?= lang('TopNav.movies') ?>
    </a>
    </li>

    <li class="nav-item <?php if($uri->getTotalSegments() >= 2 && $uri->getSegment(2) === 'shows'  ) echo 'active' ?>">
    <a href="<?= library_url([], 'shows') ?>" class="nav-link font-weight-semi-bold"><i class="fa-light fa-tv-retro"></i>&nbsp;
    <?= lang('TopNav.tv_shows') ?>
    </a>
    </li>

    <?php if(get_config('request_system')): ?>
    <li class="nav-item <?php if( $uri->getSegment(1) === 'request'  ) echo 'active' ?>">
    <a href="<?= site_url('request') ?>" class="nav-link font-weight-semi-bold "><i class="fa-regular fa-square-plus"></i>&nbsp; <?= lang('TopNav.request') ?>
    </a>
    </li>
    <?php endif; ?>

	<?php  if(! is_referer_blocked()): ?>
    <li class="nav-item <?php if( $uri->getSegment(1) === 'api'  ) echo 'active' ?>">
    <a href="<?= site_url('api') ?>" class="nav-link font-weight-semi-bold"><i class="fa-light fa-gear"></i>&nbsp;
    <?= lang('TopNav.api') ?>
    </a>
    </li>
	<?php endif; ?>
	</ul>
	
    <!-- Navbar nav -->
    <form class="form-inline ml-auto" action="..." method="..."> <!-- ml-auto = margin-left: auto -->
    <div class="input-group" style="min-width: auto">
    <div class="input-group-append">
    <button class="btn search-icon" type="button" data-toggle="modal" data-target="search-modal">
    <i class="fad fa-search"></i>
    <span class="sr-only"><?= lang('TopNav.search_placeholder') ?></span> <!-- sr-only = show only on screen readers -->
    </button>
    </div>
    </div>

    <?php if(is_multi_languages_enabled() && ! empty( get_selected_languages() )): ?>
    <div class="dropdown  ml-5">
    <button class="p-5 btn-language" data-toggle="dropdown" type="button" >
    <img  class="d-block" src="<?= lang_flag( current_language() ) ?>" width="30"alt="South Africa">
    </button>
    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdown-toggle-btn-1">
    <h6 class="dropdown-header"><div class="spinner-grow spinner-grow-sm" role="status"></div> Select Language</h6>
    <?php foreach ( get_selected_languages(true) as $lang) : ?>
    <a href="<?= lang_url( $lang ) ?>" class="dropdown-item d-flex align-items-center">
    <img  class="mr-5" src="<?= lang_flag( $lang ) ?>" width="25" alt="South Africa">
    <?= lang_name( $lang ) ?>
    </a>
    <?php endforeach; ?>
    </div>
    </div>
    <?php endif; ?>
    </form>
    </nav>
    
    