<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="author" content="IDNMarket">
    <meta name="robots" content="noindex, nofollow">
    <meta name="keywords" content="<?= isset($metaKeywords) ? esc( $metaKeywords ) : '' ?>">
    <meta name="description" content="<?= isset($metaDescription) ? esc( $metaDescription ) : '' ?>">
    
    <meta property="og:title" content="<?= esc( $movie->title ) ?>">
    <meta property="og:description" content="<?= isset($metaDescription) ? esc( $metaDescription ) : '' ?>">
    <meta property="og:url" content="<?php echo "<?= esc( $movie->getViewLink( true ) ) ?>" . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:image" content="<?= banner_uri( $activeMovie->banner ) ?>">

    <?= $this->renderSection('head') ?>
    <?php if( has_site_favicon() ): ?>
    <link rel="shortcut icon" href="<?= site_favicon() ?>" type="image/x-icon">
    <link rel="icon" href="<?= site_favicon() ?>" type="image/x-icon">
    <?php endif; ?>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    
    <link href="<?= theme_assets('/css/template.min.css?v=1.2') ?>" rel="stylesheet" />
    <link href="<?= theme_assets('/fontawesome_pro/css/all.css') ?>" rel="stylesheet" />
    <link href="<?= theme_assets('/fontawesome_pro/css/all.min.css') ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?= theme_assets('/css/custom.min.css?v=1.2') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha256-eZrrJcwDc/3uDhsdt61sL2oOBY362qM3lon1gyExkL0=" crossorigin="anonymous">

    <?php if( service('auth')->isLogged() ){ ?>
        <link href="<?= admin_assets('/css/admin-bar.css?v=1.2') ?>" rel="stylesheet">
    <?php } ?>

    <title> <?php echo isset( $title ) ? esc( get_page_title( $title ) ) : ''  ?> </title>
    <!-- header custom codes-->
    <?= header_custom_codes() ?>
    
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JQYKYWXC45"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-JQYKYWXC45');
    </script>
</head>
<body  class="dark-mode with-custom-webkit-scrollbars with-custom-css-scrollbars overflow-x-hidden

<?= service('auth')->isLogged() ? 'with-admin-bar1' : '' ?> " data-dm-shortcut-enabled="true" data-sidebar-shortcut-enabled="true" data-new-gr-c-s-check-loaded="14.1008.0" data-gr-ext-installed="">
<!-- admin bar-->

<!-- Page wrapper -->
<div id="page-wrapper" class="page-wrapper with-navbar  with-transitions" data-sidebar-type="default">

    <!-- Sticky alerts -->
    <div class="sticky-alerts"></div>

    <!-- Navbar start -->
    <?= $this->include( theme_path('__layout/navbar') ) ?>
    <!-- Navbar end -->