<div class="x_panel">
    <div class="x_title">
        <h2>Stream Links</h2>
        <ul class="nav navbar-right panel_toolbox">
            <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
            </li>
        </ul>
        <div class="clearfix"></div>
    </div>
    <div class="x_content" id="st-group-content">

        <?php if(! empty($streamLinks)): ?>
            <?php foreach ($streamLinks as $key => $link):
                $key += 1; ?>
                <div class="form-group st-group">

                    <?= form_label("Link {$key}:", "", ['class'=>'font-weight-bold']) ?>

                    <div class="link-meta-info mb-1">
                        <span class="requests-count">Requests :  <?= $link->requests ?></span>
                        <span class="status float-right">Status : <?= format_links_status( $link->is_broken ) ?> </span>
                    </div>


                    <div class="input-group">
                        <?php $fields = [
                            'type' => 'url',
                            'name' => "st_links[{$key}][url]",
                            'class' => 'form-control link',
                            'value' => old("st_links.{$key}.url", $link->link)
                        ]; if( $link->isApiBased() ) $fields['readonly'] = 'readonly' ?>
                        <?= form_input($fields) ?>

                        <span class="input-group-btn ml-2">
                                <?= form_button( [
                                    'class' => 'btn btn-light clone-st-group'
                                ],
                                    '<i class="fa fa-plus"></i>'
                                ) ?>
                            </span>
                    </div>

                    <?= form_hidden("st_links[{$key}][id]", $link->id); ?>
                    <?=  ! empty($link->api_id) ?  form_hidden("st_links[{$key}][api_id]", $link->api_id) : '' ?>


                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <?php for($i = 1; $i <= 3; $i++) : ?>
                <div class="form-group st-group" >
                    <?= form_label("Link {$i}:") ?>
                    <div class="input-group">
                        <?= form_input([
                            'type' => 'url',
                            'name' => "st_links[{$i}][url]",
                            'class' => 'form-control link',
                            'value' => old("st_links.{$i}.url")
                        ]) ?>

                        <span class="input-group-btn ml-2">
                                <?= form_button( [
                                    'class' => 'btn btn-light clone-st-group'
                                ],
                                    '<i class="fa fa-plus"></i>'
                                ) ?>
                        </span>
                    </div>



                </div>
            <?php endfor; ?>
        <?php endif; ?>




    </div>
</div>