<?php 
include ('includes/header.php');

$table_name = 'themes';

// Define default data
$data = [
    'theme_defult_layout' => 'L1', // Set a default layout
    'theme_color_1' => '',
    'theme_color_2' => '',
    'theme_color_3' => '',
    'roku_color_primary' => '',
    'roku_color_secondary' => '',
    'roku_button_focus' => '',
    'roku_button_unfocus' => '',
    'theme_change' => '',
    'roku_background_overlay' => '',
];

// Insert default data if the table is empty
$db->insertIfEmpty($table_name, $data);

// Retrieve data from the themes table
$res = $db->select($table_name, '*', '', '');

// Handle form submission
if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id', [':id' => 1]);
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

// Map layouts to display-friendly names
$layouts = [
    'L1' => 'Layout 1',
    'L2' => 'Layout 2',
    'L4' => 'Layout 3'
];

// Get the current selected layout
$currentLayout = $res[0]['theme_defult_layout'];
$currentLayoutName = $layouts[$currentLayout] ?? 'Unknown Layout';

?>

<div class="container my-5">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white text-center">
                    <h3><i class="icon icon-palette"></i> Manage Theme Layout</h3>
                </div>

                <div class="card-body">
                    <!-- Display current selected layout -->
                    <div class="alert alert-info text-center">
                        <strong>Current Selected Layout:</strong> <?= $currentLayoutName ?>
                    </div>

                    <form method="post" class="row g-3">
                        <div class="col-md-12">
                            <label for="theme_defult_layout" class="form-label">Select Default Layout</label>
                            <select class="form-select" name="theme_defult_layout" id="theme_defult_layout">
                                <option value="L1" <?= $currentLayout == 'L1' ? 'selected' : '' ?>>Layout 1</option>
                                <option value="L2" <?= $currentLayout == 'L2' ? 'selected' : '' ?>>Layout 2</option>
                                <option value="L4" <?= $currentLayout == 'L4' ? 'selected' : '' ?>>Layout 3</option>
                            </select>
                        </div>

                        <div class="col-12 text-center">
                            <button type="submit" name="submit" class="btn btn-success mt-3">
                                <i class="icon icon-check"></i> Save Layout
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Layout Image Previews with Highlight for Current Layout -->
    <div class="row my-5 text-center">
        <div class="col-md-4">
            <div class="card <?= $currentLayout == 'L1' ? 'border-success' : 'border-light' ?> shadow-sm">
                <img src="img/theme_1.png" class="card-img-top" alt="Layout 1" style="max-height: 200px;">
                <div class="card-body">
                    <p class="card-text">Layout 1</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card <?= $currentLayout == 'L2' ? 'border-success' : 'border-light' ?> shadow-sm">
                <img src="img/theme_2.png" class="card-img-top" alt="Layout 2" style="max-height: 200px;">
                <div class="card-body">
                    <p class="card-text">Layout 2</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card <?= $currentLayout == 'L4' ? 'border-success' : 'border-light' ?> shadow-sm">
                <img src="img/theme_4.png" class="card-img-top" alt="Layout 3" style="max-height: 200px;">
                <div class="card-body">
                    <p class="card-text">Layout 3</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
